% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Comparator.R, R/CppSeqComparator.R,
%   R/StringComparator.R, R/NumericComparator.R, R/Chebyshev.R,
%   R/FuzzyTokenSet.R, R/InVocabulary.R, R/Lookup.R, R/MongeElkan.R
\name{elementwise}
\alias{elementwise}
\alias{elementwise,CppSeqComparator,list,list-method}
\alias{elementwise,StringComparator,vector,vector-method}
\alias{elementwise,NumericComparator,matrix,vector-method}
\alias{elementwise,NumericComparator,vector,matrix-method}
\alias{elementwise,NumericComparator,vector,vector-method}
\alias{elementwise,Chebyshev,matrix,matrix-method}
\alias{elementwise,FuzzyTokenSet,list,list-method}
\alias{elementwise,InVocabulary,vector,vector-method}
\alias{elementwise,Lookup,vector,vector-method}
\alias{elementwise,MongeElkan,list,list-method}
\title{Elementwise Similarity/Distance Vector}
\usage{
elementwise(comparator, x, y, ...)

\S4method{elementwise}{CppSeqComparator,list,list}(comparator, x, y, ...)

\S4method{elementwise}{StringComparator,vector,vector}(comparator, x, y, ...)

\S4method{elementwise}{NumericComparator,matrix,vector}(comparator, x, y, ...)

\S4method{elementwise}{NumericComparator,vector,matrix}(comparator, x, y, ...)

\S4method{elementwise}{NumericComparator,vector,vector}(comparator, x, y, ...)

\S4method{elementwise}{Chebyshev,matrix,matrix}(comparator, x, y, ...)

\S4method{elementwise}{FuzzyTokenSet,list,list}(comparator, x, y, ...)

\S4method{elementwise}{InVocabulary,vector,vector}(comparator, x, y, ...)

\S4method{elementwise}{Lookup,vector,vector}(comparator, x, y, ...)

\S4method{elementwise}{MongeElkan,list,list}(comparator, x, y, ...)
}
\arguments{
\item{comparator}{a comparator used to compare the objects, which is a
sub-class of \code{\linkS4class{Comparator}}.}

\item{x, y}{a collection of objects to compare, typically stored as entries
in an atomic vector, rows in a matrix, or entries in a list. The required
format depends on the type of \code{comparator}. If \code{x} and \code{y} do not contain
the same number of objects, the smaller collection is recycled according
to standard \code{R} behavior.}

\item{...}{other parameters passed on to other methods.}
}
\value{
Every object in \code{x} is compared to every object in \code{y} elementwise
(with recycling) using the given comparator, to produce a numeric vector of
scores of length \eqn{max{size(x), size(y)}}.
}
\description{
Computes elementwise similarities/distances between two collections of
objects (strings, vectors, etc.) using the provided comparator.
}
\section{Methods (by class)}{
\itemize{
\item \code{comparator = CppSeqComparator,x = list,y = list}: Specialization for \code{\linkS4class{CppSeqComparator}} where
\code{x} and \code{y} are lists of sequences (vectors) to compare.

\item \code{comparator = StringComparator,x = vector,y = vector}: Specialization for \code{\linkS4class{StringComparator}} where
\code{x} and \code{y} are vectors of strings to compare.

\item \code{comparator = NumericComparator,x = matrix,y = vector}: Specialization for \code{\linkS4class{NumericComparator}} where
\code{x} is a matrix of rows (interpreted as vectors) to compare with a vector
\code{y}.

\item \code{comparator = NumericComparator,x = vector,y = matrix}: Specialization for \code{\linkS4class{NumericComparator}} where
\code{x} is a vector to compare with a matrix \code{y} of rows (interpreted as
vectors).

\item \code{comparator = NumericComparator,x = vector,y = vector}: Specialization for \code{\linkS4class{NumericComparator}} where
\code{x} and \code{y} are vectors to compare.

\item \code{comparator = Chebyshev,x = matrix,y = matrix}: Specialization for \code{\link{Chebyshev}} where \code{x} and \code{y}
matrices of rows (interpreted as vectors) to compare. If \code{x} any \code{y} do
not have the same number of rows, rows are recycled in the smaller matrix.

\item \code{comparator = FuzzyTokenSet,x = list,y = list}: Specialization for \code{\link{FuzzyTokenSet}} where \code{x} and \code{y}
are lists of token vectors to compare.

\item \code{comparator = InVocabulary,x = vector,y = vector}: Specialization for \code{\link{InVocabulary}} where \code{x} and
\code{y} are vectors of strings to compare.

\item \code{comparator = Lookup,x = vector,y = vector}: Specialization for a \code{\link{Lookup}} where \code{x} and \code{y}
are vectors of strings to compare

\item \code{comparator = MongeElkan,x = list,y = list}: Specialization for \code{\link{MongeElkan}} where \code{x} and \code{y}
lists of token vectors to compare.
}}

\note{
This function is not strictly necessary, as the \code{comparator} itself is a
function that returns elementwise vectors of scores. In other words,
\code{comparator(x, y, ...)} is equivalent to
\code{elementwise(comparator, x, y, ...)}.
}
\examples{
## Compute the absolute difference between two sets of scalar observations
data("iris")
x <- as.matrix(iris$Sepal.Width)
y <- as.matrix(iris$Sepal.Length)
elementwise(Euclidean(), x, y)

## Compute the edit distance between columns of two linked data.frames
col.1 <- c("Hasna Yuhanna", "Korina Zenovia", "Phyllis Haywood", "Nicky Ellen")
col.2 <- c("Hasna Yuhanna", "Corinna Zenovia", "Phyllis Dorothy Haywood", "Nicole Ellen")
elementwise(Levenshtein(), col.1, col.2)
Levenshtein()(col.1, col.2)               # equivalent to above

## Recycling is used if the two collections don't contain the same number of objects
elementwise(Levenshtein(), "Cora Zenovia", col.1)

}
