% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_c_stat.R
\name{compare_c_stat}
\alias{compare_c_stat}
\title{Compare C-statistics Between Two Models with Bootstrapped or Uno's C Confidence Intervals}
\usage{
compare_c_stat(
  model_raw,
  model_ext,
  data,
  R = 10,
  ci_type = "perc",
  method = "Harrell",
  tau = NULL
)
}
\arguments{
\item{model_raw}{A fitted model (e.g., coxph) representing the base model.}

\item{model_ext}{A fitted model (e.g., coxph) representing the extended model.}

\item{data}{The dataset used for fitting the models.}

\item{R}{Number of bootstrap or perturbation-resampling replications. Default is 100.}

\item{ci_type}{Type of confidence interval to return ("perc", "norm", "basic", etc., for Harrell's C).}

\item{method}{Which C-statistic to use: "Harrell" (default) or "Uno".}

\item{tau}{Truncation time for Uno's C (default is max observed time in your data).}
}
\value{
A data frame showing C-statistics for each model, their confidence intervals, and the p-value for the difference.
}
\description{
This function compares the C-statistics of two fitted models using either bootstrap resampling
(Harrell's C) or Uno's C via perturbation-resampling (survC1 package).
}
\examples{
library(survival)
data(lung)
lung$status <- ifelse(lung$status == 2, 1, 0)
model1 <- coxph(Surv(time, status) ~ age, data = lung)
model2 <- coxph(Surv(time, status) ~ age + sex, data = lung)
compare_c_stat(model1, model2, data = lung, R = 10, method = "Harrell")
compare_c_stat(model1, model2, data = lung, R = 10, method = "Uno")
compare_c_stat(model1, model2, data = lung, R = 10, method = "Uno", tau = 365.25*2)
}
\references{
Uno H, Cai T, Pencina MJ, D'Agostino RB, Wei LJ. (2011) On the C-statistics for evaluating overall adequacy of risk prediction procedures with censored survival data. \emph{Statistics in Medicine}, 30(10):1105-1117. \doi{10.1002/sim.4154}
}
