% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlm.wfit.R
\name{summary.zlm}
\alias{summary.zlm}
\alias{print.summary.zlm}
\title{Summarize Complex Linear Model Fits.}
\usage{
\method{summary}{zlm}(object, correlation = FALSE, symbolic.cor = FALSE, ...)

\method{print}{summary.zlm}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  symbolic.cor = x$symbolic.cor,
  quantiles = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class "zlm". Presumably returned by \link{lm}. May contain complex variables.}

\item{correlation}{Logical. If TRUE, the correlation matrix of the estimated parameters is returned and printed.}

\item{symbolic.cor}{Logical. If TRUE, print the correlations in a symbolic form (see \link[stats:symnum]{stats::symnum}) rather than as numbers. (This may not work.)}

\item{...}{Further arguments passed to or from other methods.}

\item{x}{a 'zlm' object or an 'zlm' summary object. Used for \code{print.summary.zlm}}

\item{digits}{the number of digits to include in the printed report, default is three. Used for \code{print.summary.zlm}}

\item{quantiles}{logical. Should the (inaccurate) quantiles of the residuals be printed? If \code{FALSE} \link{summary.complex} is applied to the residuals instead.}
}
\value{
Returns an object of class "summary.zlm" and "summary.lm", that is a list containing the following elements.
\item{\code{residuals}}{Complex or numeric. The weighted residuals, that is the measured value minus the fitted value, scaled by the square root of the weights given in the call to lm.}
\item{\code{correlation}}{A complex matrix with real diagonal elements. The computed correlation coefficient matrix for the coefficients in the model.}
\item{\code{pseudocorrelation}}{A complex matrix. The computed pseudo-correlation coefficient matrix for the coefficients in the model.}
\item{\code{cov.unscaled}}{The unscaled covariance matrix; i.e, a complex matrix with real diagonal elements such that multiplying it by an estimate of the error variance produces an estimated covariance matrix for the coefficients.}
\item{\code{pcov.unscaled}}{The unscaled pseudo-covariance matrix; i.e, a complex matrix such that multiplying it by an estimate of the error pseudo-variance produces an estimated pseudo-covariance matrix for the coefficients.}
\item{\code{sigma}}{Numeric. The square root of the estimated variance of the random error.}
\item{\code{psigma}}{Complex. The square root of the estimated pseudo-variance of the random error. See details above.}
\item{\code{df}}{The number of degrees of freedom for the model and for residuals. A 3 element vector (p, n-p, p*), the first being the number of non-aliased coefficients, the last being the total number of coefficients.}
\item{\code{coefficients}}{A 5 column matrix that contains the model coefficients, their standard errors, their pseudo standard errors (see details above), their t statistics, and corresponding (two-sided) p-value. Aliased coefficients are omitted.}
\item{\code{aliased}}{Named logical vector showing if the original coefficients are aliased.}
\item{\code{terms}}{The terms object used in fitting this model.}
\item{\code{fstatistic}}{(for models including non-intercept terms) a 3 element numeric vector with the value of the F-statistic with its numerator and denominator degrees of freedom.}
\item{\code{r.squared}}{Numeric. The fraction of variance explained by the model.}
\item{\code{adj.r.squared}}{the above R^2 statistic "adjusted", penalizing for higher p.}
\item{\code{symbolic.cor}}{(only if \code{correlation} is true.) The value of the argument symbolic.cor.}
\item{\code{na.action}}{from \code{object}, if present there.}
}
\description{
Summary method for complex linear fits of class "zlm".
Based off of, and very similar to \link[stats:summary.lm]{stats::summary.lm}. However it does not delve into quantiles or 'significance stars', and includes the 'pseudo variance'.
}
\details{
See \link[stats:summary.lm]{stats::summary.lm} for more information.
In addition to the information returned by \code{stats::summary.lm}, this complex variable compatible version also returns
"pseudo standard error" or "relational standard error" which is the square root of the "pseudo-variance".
This is a complex number that quantifies the covariance between the real and imaginary parts. Can also be thought of as the amount and direction of anisotropy of the
(presumed complex normal) probability distribution of the residuals in the complex plane. The argument of this number gives the direction of the semi-major axis of an iso-probability-density ellipse
centered on the mean, while its modulus is the length of the semi-major axis. The variance, meanwhile, gives the area of this ellipse, divided by pi. Together they fully describe it.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(summary.zlm)}: S3 method for class 'summary.zlm'

}}
\note{
\code{print.summary.zlm} calls \code{print.summary.rzlm}

For complex fits the quantiles reported by this function are based on sorting the real parts of the residuals. They should not be considered reliable..
}
\examples{
set.seed(4242)
n <- 8
slop <- complex(real = 4.23, imaginary = 2.323)
interc <- complex(real = 1.4, imaginary = 1.804)
e <- complex(real=rnorm(n)/6, imaginary=rnorm(n)/6)
xx <- complex(real= rnorm(n), imaginary= rnorm(n))
tframe <- data.frame(x = xx, y= slop*xx + interc + e)
fit <- lm(y ~ x, data = tframe, weights = rep(1,n))
summ <- summary(fit)
print(summ)
}
\seealso{
\link{lm}, \link{rlm}
}
