% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_config.R
\name{add_datasource}
\alias{add_datasource}
\title{Add a new datasource to a YAML configuration file}
\usage{
add_datasource(config_path, name, backend)
}
\arguments{
\item{config_path}{The file path to the YAML configuration file}

\item{name}{The name of the new datasource}

\item{backend}{A named list representing the backend configuration for the new datasource}
}
\value{
(invisible) \code{config_path} where the configuration have been updated
}
\description{
This function adds a new datasource to a YAML configuration file by appending the
provided datasource information to the existing datasources.
}
\examples{
config <- tempfile(fileext = ".yml")

file.copy(
  from = system.file("config", "_connector.yml", package = "connector"),
  to = config
)

config <- config |>
  add_datasource(
    name = "new_datasource",
    backend = list(type = "connector_fs", path = "new_path")
  )
config
}
