% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateHelpers.R
\name{makeItemDfs}
\alias{makeItemDfs}
\title{makeItemDfs}
\usage{
makeItemDfs(itemList)
}
\arguments{
\item{itemList}{a list of item matrices. The structure of each
matrix is the same as used in \code{conquestr::simplef}
(a matrix of k categories by four (category score, delta dot, tau, discrimination)).}
}
\value{
a list.
}
\description{
takes in a list of item matrices and returns a list of data frames
each representing the parameters given in the matrices. The return object is
suitable to pass into \code{conquestr::makeItemList} to construct a lit of matrices
where each matrix represent one item's set of item parameters. The structure of the
matrix is the same as used in \code{conquestr::simplef}
(a matrix of k categories by four (category score, delta dot, tau, discrimination)).
A common use for this function is turn a list of item matrices into a flat data
structure.
}
\examples{
nItems <- 10
myItemsDeltaDot <- data.frame(
  id= seq(nItems),
  itemid= NA,
  delta = runif (nItems, -4, 1) # nItems items in range -4,1
)
myItemsList <- conquestr::makeItemList(deltaDot = myItemsDeltaDot)
}
