% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-citation.R
\name{get_citation}
\alias{get_citation}
\title{Get citation from a DOI}
\usage{
get_citation(
  doi,
  style = c("bibtex", "apa", "harvard-cite-them-right", "modern-language-association",
    "vancouver", "chicago-fullnote-bibliography", "ieee"),
  verbose = TRUE
)
}
\arguments{
\item{doi}{A string, the Zenodo DOI or concept DOI.}

\item{style}{A string, the citation style. Default is "bibtex". Possible
values are: "bibtex", "harvard-cite-them-right", "apa",
"modern-language-association", "vancouver",
"chicago-fullnote-bibliography", or "ieee".}

\item{verbose}{logical. Should messages during citation fetching print to
the screen? Default is TRUE.}
}
\value{
A character string containing the citation in the requested style.
For \code{"bibtex"} style, returns an object of class \code{"csbib"}.
}
\description{
This is a wrapper around \code{\link[zen4R:get_citation]{zen4R::get_citation()}} with a couple of smaller
changes. Firstly, it silences output from \code{\link[zen4R:get_citation]{zen4R::get_citation()}}, secondly
the default citation style is "apa".
}
\examples{
\donttest{
polymod_doi <- "https://doi.org/10.5281/zenodo.3874557"
get_citation(polymod_doi)
}
}
