% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation_tests.R
\name{rotation_null_test}
\alias{rotation_null_test}
\title{Rotation null hypothesis test for factor coupling}
\usage{
rotation_null_test(
  scores_X,
  scores_Y,
  lag = 1,
  B = 1000,
  seed = 123,
  compute = c("procrustes", "cca", "principal", "dynbeta"),
  progress = TRUE,
  rotate = "Y"
)
}
\arguments{
\item{scores_X}{Factor scores from first dataset}

\item{scores_Y}{Factor scores from second dataset}

\item{lag}{Number of lags for the model (default: 1)}

\item{B}{Number of bootstrap iterations (default: 1000)}

\item{seed}{Random seed for reproducibility (default: 123)}

\item{compute}{Vector of methods to compute: 'procrustes', 'cca', 'principal', 'dynbeta'}

\item{progress}{Logical, show progress bar (default: TRUE)}

\item{rotate}{Which dataset to rotate: 'X' or 'Y' (default: 'Y')}
}
\value{
List with components:
\describe{
\item{\code{observed}}{Observed correlation statistics.}
\item{\code{null_distribution}}{Matrix of statistics under null rotations.}
\item{\code{p_values}}{One-sided p-values for each statistic.}
\item{\code{significant}}{Logical indicating significance at alpha = 0.05.}
}
}
\description{
Tests whether the observed correlation structure between X and Y factor spaces
is significantly stronger than would be expected under random orthogonal rotations.
}
\details{
(contemporaneous).
"spearman", or "kendall".
}
