% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.r
\name{store_cookies}
\alias{store_cookies}
\title{Store cookies in a jar}
\usage{
store_cookies(cookies, jar = default_jar(), confirm = FALSE)
}
\arguments{
\item{cookies}{A data frame of cookies}

\item{jar}{The directory to store the cookies in. Defaults to
\code{default_jar()}.}

\item{confirm}{If \code{TRUE}, you confirm to write the cookie jar to disk
(if it does not exist yet) without seeing the interactive menu.}
}
\value{
No return value, called to save (encrypted) cookies on disk.
}
\description{
Store cookies in a jar
}
\examples{
# to conform with CRAN policies, examples use a temporary location. Do not use
# the options like this, except you want your cookies gone when closing R.
options(cookie_dir = tempdir())

if (requireNamespace("curl", quietly = TRUE)) {
  # get cookies from a curl request
  library(curl)
  h <- new_handle()
  resp <- curl_fetch_memory("https://hb.cran.dev/cookies/set?new_cookies=moo", handle = h)
  cookies <- handle_cookies(h)

  # then store them for future use
  store_cookies(cookies)

  # then you can retrieve them and use in future calls
  get_cookies("hb.cran.dev")
}
}
