% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortlist.R
\name{sortlist}
\alias{sortlist}
\title{Sort List Entries Alphabetically}
\usage{
sortlist(lst, recursive = TRUE, convert.data.frames = FALSE)
}
\arguments{
\item{lst}{list to be sorted.}

\item{recursive}{logical flag indicating whether to apply sorting recursively to all sublists.
Defaults to \code{TRUE}. If \code{FALSE}, only the top-level entries in the list will be sorted.}

\item{convert.data.frames}{logical flag. If \code{TRUE}, data frames are converted to lists.}
}
\value{
Structured list with alphabetically sorted entries. If \code{recursive = TRUE}, all sublists
  are also sorted alphabetically. If the list contains unnamed elements, they are left unsorted.
}
\description{
This function sorts the entries of a structured list in alphabetical order, including all nested sublists
recursively, making it easier to navigate nested list structures and compare different lists. Unnammed items are listed last.
Attributes of the original list are preserved.
}
\examples{
# Create a nested list
my_list = list(
b = list(d = 4, a = 2),
empty = list(),
'unnamed',
a = 1,
f = list(b = 3, a = list(d = seq(5), 'unnamed', c = 2))
)

# Sort the list recursively
sorted_list_recursive = sortlist(my_list)
print(sorted_list_recursive)

}
