% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_events.R
\name{set_events}
\alias{set_events}
\title{Set, create or modify columns with Event information}
\usage{
set_events(
  .df,
  eventID = NULL,
  eventType = NULL,
  parentEventID = NULL,
  .keep = "unused",
  .keep_composite = "all"
)
}
\arguments{
\item{.df}{A \code{data.frame} or \code{tibble} that the column should be appended to.}

\item{eventID}{A unique identifier for an individual Event.}

\item{eventType}{The type of Event}

\item{parentEventID}{The parent event under which one or more Events sit
within.}

\item{.keep}{Control which columns from \code{.df} are retained in the output.
Note that unlike \code{\link[dplyr:mutate]{dplyr::mutate()}}, which defaults to \code{"all"} this defaults
to \code{"unused"}; i.e. only keeps Darwin Core columns, and not those columns used
to generate them.}

\item{.keep_composite}{Control which columns from \code{.df} are kept when
\code{\link[=composite_id]{composite_id()}} is used to assign values to \code{eventID}, defaulting to
\code{"all"}. This has a different default from \code{.keep} because composite
identifiers often contain information that is valuable in other contexts,
meaning that deleting these columns by default is typically unwise.}
}
\value{
A \code{tibble} with the requested fields added/reformatted.
}
\description{
Identify or format columns that contain information about an
\href{https://dwc.tdwg.org/list/#dwc_Event}{Event}. An "Event" in Darwin Core
Standard refers to an action that occurs at a place and time. Examples
include:
\itemize{
\item A specimen collecting event
\item A survey or sampling event
\item A camera trap image capture
\item A marine trawl
\item A camera trap deployment event
\item A camera trap burst image event (with many images for one observation)
}

In practice this function is used no differently from \code{mutate()}, but gives
users some informative errors, and serves as a useful lookup for fields in
the Darwin Core Standard.
}
\details{
Each Event requires a unique \code{eventID} and \code{eventType} (because there can
be several types of Events in a single dataset), along with a
\code{parentEventID} which specifies the level under which the current Event sits
(e.g., An individual location's survey event ID, which is one of several
survey locations on a specific day's set of surveys ie the parentEvent).

Examples of \code{eventID} values:
\itemize{
\item \code{INBO:VIS:Ev:00009375}
}

Examples of \code{eventType} values:
\itemize{
\item \code{Sample}
\item \code{Observation}
\item \code{Survey}
\item \verb{Site Visit}
\item \code{Deployment}
See more examples on \href{https://dwc.tdwg.org/list/#dwc_eventType}{dwc.tdwg.org}
}

Examples of \code{parentEventID}
\code{A1} (To identify the parent event in nested samples, each with their own \code{eventID} - \code{A1_1}, \code{A1_2})
}
\examples{
# example Event dataframe
df <- tibble::tibble(
  site_code = c("AMA100", "AMA100", "AMH100"),
  scientificName = c("Crinia signifera", "Crinia signifera", "Crinia signifera"),
  latitude = c(-35.275, -35.274, -35.101),
  longitue = c(149.001, 149.004, 149.274),
  )

# Add event information
df |>
  set_events(
    eventID = composite_id(sequential_id(),
                           site_code,
                           year),
    eventType = "Survey"
    )

}
