% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_text.R
\name{cor_text}
\alias{cor_text}
\title{Correlation text}
\usage{
cor_text(x, show_ci = TRUE, show_statistic = TRUE, show_sig = TRUE, ...)
}
\arguments{
\item{x}{A dataframe with correlation statistics.}

\item{show_ci, show_statistic, show_sig}{Toggle on/off different parts of the text.}

\item{...}{Other arguments to be passed to or from other functions.}
}
\description{
This function returns a formatted character of correlation statistics.
}
\examples{
rez <- cor_test(mtcars, "mpg", "wt")

cor_text(rez)
cor_text(rez, show_statistic = FALSE, show_ci = FALSE, stars = TRUE)

rez <- correlation(mtcars)

cor_text(rez)
}
