% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy_pair.R
\name{entropy_pair}
\alias{entropy_pair}
\title{Calculate Entropy of a Pair}
\usage{
entropy_pair(table)
}
\arguments{
\item{table}{A numeric vector or matrix. A contingency table or frequency table of a pair of variables.}
}
\value{
A numeric value representing the entropy of the pair.
}
\description{
This function calculates the entropy of a pair of variables (or a pairwise contingency table)
based on the probability distribution of their joint occurrences.
}
\details{
The entropy is calculated using the formula:
[ H(X, Y) = - sum p(x, y) * log_2(p(x, y)) ]
where \( p(x, y) \) is the probability of observing the pair \( (x, y) \) from the table.
}
\examples{
# Example usage with a simple contingency table:
pair_table <- table(c(1, 2, 2, 3), c(1, 1, 2, 2))
entropy_pair(pair_table)

}
