% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_odds_dc.R
\name{log_odds_dc}
\alias{log_odds_dc}
\title{Log-Odds Calculation for Concordant and Discordant Pairs}
\usage{
log_odds_dc(tab)
}
\arguments{
\item{tab}{A contingency table (matrix or data frame) containing counts of pairs
for each combination of outcomes.}
}
\value{
The log-odds ratio calculated as the natural logarithm of the ratio of
concordant pairs to discordant pairs. If discordant pairs are zero,
it returns \code{Inf} to avoid division by zero.
}
\description{
This function calculates the log-odds ratio for concordant and discordant pairs
based on the contingency table provided. The log-odds ratio is defined as the
natural logarithm of the ratio of concordant to discordant pairs.
}
\examples{
# Example contingency table
tab <- matrix(c(10, 5, 7, 8), nrow = 2)
log_odds_dc(tab)

}
