# tests/testthat/test-blend.R

test_that("blend_words creates portmanteaus", {
  # Classic: breakfast + lunch = brunch
  result <- blend_words("breakfast", "lunch")
  expect_type(result, "character")
  expect_true(nchar(result) > 0)
  # Should start with part of first word
  expect_true(startsWith(result, "br"))
})

test_that("blend_words handles refudiate", {
  # refute + repudiate = refudiate
  result <- blend_words("refute", "repudiate")
  expect_type(result, "character")
})

test_that("detect_blend identifies components", {
  result <- detect_blend("brunch", c("breakfast", "lunch", "dinner", "snack"))
  expect_true("breakfast" %in% result)
  expect_true("lunch" %in% result)
})

test_that("blend_score measures blend quality", {
  score <- blend_score("brunch", "breakfast", "lunch")
  expect_type(score, "double")
  expect_true(score >= 0 && score <= 1)
})
