# tests/testthat/test-syllable.R

test_that("syllabify splits words correctly", {
  expect_equal(syllabify("hello"), c("hel", "lo"))
  expect_equal(syllabify("coverage"), c("cov", "er", "age"))
  expect_equal(syllabify("president"), c("pres", "i", "dent"))
})

test_that("syllable_count is accurate", {
  expect_equal(syllable_count("hello"), 2)
  expect_equal(syllable_count("coverage"), 3)
  expect_equal(syllable_count("I"), 1)
})

test_that("onset_nucleus_coda parses correctly", {
  result <- onset_nucleus_coda("cat")
  expect_equal(result$onset, "c")
  expect_equal(result$nucleus, "a")
  expect_equal(result$coda, "t")
})

test_that("syllable_swap exchanges syllables", {
  # Swap first syllables of two words
  result <- syllable_swap("coverage", "president", 1)
  expect_equal(result, c("preserage", "covident"))
})
