% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-gene.R
\name{plot_cpam}
\alias{plot_cpam}
\title{Plot fitted changepoint additive models}
\usage{
plot_cpam(
  cpo,
  gene_id = NULL,
  target_id = NULL,
  cp_type = c("cp_1se", "cp_min"),
  shape_type = "shape1",
  bs = "auto",
  cp_fix = -1,
  facet = FALSE,
  sp = NULL,
  show_fit = TRUE,
  show_data = TRUE,
  show_fit_ci = TRUE,
  show_data_ci = TRUE,
  ci_prob = "se",
  remove_null = FALSE,
  null_threshold = 0.05,
  null_threshold_adj = TRUE,
  k_mult = 1.2,
  return_fits_only = FALSE,
  family = "nb",
  common_y_scale = TRUE,
  scaled = FALSE,
  base_size = 12
)
}
\arguments{
\item{cpo}{A cpam object containing count data, model fits, and optional changepoint/shape estimates}

\item{gene_id}{character; gene_id (mutually exclusive with target_id)}

\item{target_id}{character; target_id (mutually exclusive with gene_id)}

\item{cp_type}{One of "cp_1se" or "cp_min"; rule for selecting changepoint from fitted models.
See \code{\link[=estimate_changepoint]{estimate_changepoint()}} for details.}

\item{shape_type}{One of "shape1" or "shape2"; which set of fitted shape patterns to use.
See \code{\link[=select_shape]{select_shape()}} for details.}

\item{bs}{Shape pattern to fit ("null", "lin", "ilin", "dlin", or from cpo$bss).
Use "auto" (default) to use estimated shapes as per \code{shape_type}.}

\item{cp_fix}{Numeric; fixed changepoint time. Set to -1 (default) to use estimated changepoints}

\item{facet}{Logical; for multiple transcripts, plot in separate facets?}

\item{sp}{numerical; set the smooth parameter. NULL (default) for automatic selection}

\item{show_fit}{logical; show the fitted trend?}

\item{show_data}{logical; show (possibly normalized and scaled) data points?}

\item{show_fit_ci}{logical; show credible interval for the fitted trend?}

\item{show_data_ci}{logical; show bootstrapped quantile for data points?}

\item{ci_prob}{"se" for standard error bands (see \code{\link[mgcv:predict.gam]{mgcv::predict.gam()}}), or numeric for simulation-based intervals.
If numerical, sets the probability for the simulation-based estimates of credible interval.}

\item{remove_null}{logical; only plot differentially expressed transcripts (not applicable for gene-only analyses)}

\item{null_threshold}{numeric; P value threshold for filtering out NULL transcripts}

\item{null_threshold_adj}{logical; use adjusted (default) or non-adjusted p-values for filtering targets}

\item{k_mult}{numerical; multiplier for the number of knots in the spline. Not recommended to change this value.}

\item{return_fits_only}{logical; return the model fits. Does not plot the function}

\item{family}{character; negative binomial ("nb", default) or Gaussian ("gaussian")}

\item{common_y_scale}{logical; for faceted plots of multiple transcripts, should the scale of the y-axis
be common or free.}

\item{scaled}{logical; scaled data by overdispersions (for bootstrapped data only)}

\item{base_size}{numeric; base font size for the plot}
}
\value{
a ggplot object
}
\description{
Plot fitted changepoint additive models
}
\details{
Plots the fitted trend and data points for a given gene or target. If a gene ID
is supplied, the function will plot all transcripts for that gene.
The function can also be used to return the model fit(s) only, which are
\code{gamObject} objects from the \code{mgcv} package.
}
\examples{
library(cpam)

# load gene-only example cpam object
load(system.file("extdata", "cpo_example.rda", package = "cpam"))

# example gene
plot_cpam(cpo_example, gene_id = "g003")

# gene with estimated changepoint at timepoint 3
plot_cpam(cpo_example, gene_id = "g013")

# manually set the changepoint
plot_cpam(cpo_example, gene_id = "g013", cp_fix = 2)

}
