% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\name{gg_forest_plot}
\alias{gg_forest_plot}
\title{Create a Custom Forest Plot}
\usage{
gg_forest_plot(data, header = "", xlim = c(0.1, 10), logx = TRUE, vline = 1)
}
\arguments{
\item{data}{(\code{data.frame})\cr
A data frame (tibble) containing the plot data. It must include
columns: \code{estimate}, \code{ci_lower},
\code{ci_upper}, and \code{n} (for point size).}

\item{header}{Forest header}

\item{xlim}{(\code{numeric(2)})\cr
A numeric vector of length 2 specifying the limits of the x-axis
(e.g., \code{c(0.1, 10)}).}

\item{logx}{(\code{logical(1)})\cr
A logical value indicating whether the x-axis should be log-transformed
(i.e., using \code{\link[ggplot2:scale_continuous]{ggplot2::scale_x_log10()}}). The default is \code{TRUE}, which is typical
for effect measures like Odds Ratios or Hazard Ratios.}

\item{vline}{(\code{numeric(1)})\cr
A numeric value specifying the x-intercept for the vertical
reference line (line of no effect). The default is \code{1}.}
}
\value{
A 'ggplot' object representing the forest plot.
}
\description{
Generates a forest plot using \code{ggplot2} from a data frame containing
estimates, confidence intervals, and sample sizes. This function is designed
to be a component of a combined table/plot output (e.g., used by \code{\link[=g_forest]{g_forest()}}).
}
\examples{
\dontrun{
# Assuming 'forest_data' is structured correctly:
forest_data <- data.frame(
  estimate = c(0.5, 2.0),
  ci_lower = c(0.2, 1.5),
  ci_upper = c(0.9, 3.5),
  n = c(100, 250)
)

gg_forest_plot(forest_data)
gg_forest_plot(forest_data, xlim = c(0.05, 50), vline = 1)
}
}
\keyword{internal}
