% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcf.R
\name{dcf_calculate}
\alias{dcf_calculate}
\title{Unlevered discounted cash flow model for a commercial real estate asset}
\usage{
dcf_calculate(
  acq_price,
  entry_yield,
  exit_yield,
  horizon_years,
  disc_rate,
  exit_cost = 0,
  capex = 0,
  index_rent = 0,
  vacancy = 0,
  opex = 0,
  noi = NULL
)
}
\arguments{
\item{acq_price}{Numeric scalar. Acquisition price (net of tax or all-in,
depending on the chosen convention).}

\item{entry_yield}{Numeric scalar in \code{[0, 1]}. Entry yield; in top-down mode,
\code{NOI[1] = entry_yield * acq_price}.}

\item{exit_yield}{Numeric scalar in \code{(0, 1]}. Exit yield.}

\item{horizon_years}{Integer scalar greater than or equal to 1. Projection horizon \code{N} in years.}

\item{disc_rate}{Numeric scalar in \code{(0, 1]}. Discount rate.}

\item{exit_cost}{Numeric scalar in \code{[0, 1)}. Exit cost as a fraction of the sale price. Default is 0.}

\item{capex}{Numeric scalar or numeric vector of length \code{N}. Capital expenditure per year. Default is 0.}

\item{index_rent}{Numeric scalar or numeric vector of length \code{N}. Annual rent indexation rate.
Used only in top-down mode. Default is 0.}

\item{vacancy}{Numeric scalar or numeric vector of length \code{N} in \code{[0, 1)}. Average annual vacancy.
Used only in top-down mode. Default is 0.}

\item{opex}{Numeric scalar or numeric vector of length \code{N}. Operating expenses (non-recoverable). Default is 0.}

\item{noi}{Numeric scalar or numeric vector of length \code{N}, optional. Exogenous NOI path (for example
computed from leases). When non-\code{NULL}, it replaces the internal NOI calculation.}
}
\value{
A list with:
\itemize{
\item \code{inputs}: list of main assumptions,
\item \code{cashflows}: tibble 0..N with standardised columns,
\item \code{npv}: project net present value (NPV),
\item \code{irr_project}: project internal rate of return (IRR), unlevered.
}
}
\description{
Builds an indexed annual pro forma over years 0..N, a terminal value, and
unlevered valuation metrics including net present value (NPV) and internal
rate of return (IRR) for a directly held commercial real estate (CRE) asset,
without debt. The income base is net operating income (NOI).
}
\details{
Time convention: \code{year = 0..N}. The acquisition is booked at \code{year = 0}
in \code{free_cash_flow} as a negative cash flow equal to the acquisition price,
and the sale is booked only at \code{year = N} in \code{sale_proceeds}. The
project NPV corresponds to the sum of \code{discounted_cash_flow}.

Two construction modes are available for the NOI path:

\itemize{
\item \strong{Top-down mode} (default): when \code{noi} is \code{NULL}, the NOI
path is derived from the entry yield and acquisition price:
\code{NOI[1] = entry_yield * acq_price}, then indexed with \code{index_rent}
and adjusted by \code{vacancy}.
\item \strong{Bottom-up mode}: when \code{noi} is supplied (scalar or vector), it
is recycled to length \code{N} and used as the \code{NOI[1..N]} path. In this
case, \code{entry_yield}, \code{index_rent}, and \code{vacancy} are not used to
recompute NOI.
}
}
\examples{
res <- dcf_calculate(
  acq_price = 1000,
  entry_yield = 0.06,
  exit_yield = 0.055,
  horizon_years = 3,
  disc_rate = 0.08,
  capex = c(5, 5, 0),
  index_rent = c(0.01, 0.01, 0.01),
  vacancy = c(0.05, 0.05, 0),
  opex = c(10, 10, 10)
)
res$npv
res$irr_project
head(res$cashflows)

}
