% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{police_shootings_tbl_df}
\alias{police_shootings_tbl_df}
\title{Fatal Police Shootings data}
\format{
A tibble with 6,421 observations and 12 variables:
\describe{
  \item{date}{Date of the shooting (Date).}
  \item{manner_of_death}{How the individual died (character).}
  \item{armed}{Indicates if the individual was armed (character).}
  \item{age}{Age of the individual (numeric).}
  \item{gender}{Gender of the individual (character).}
  \item{race}{Race of the individual (character).}
  \item{city}{City where the shooting occurred (character).}
  \item{state}{State where the shooting occurred (character).}
  \item{signs_of_mental_illness}{Whether the individual showed signs of mental illness (logical).}
  \item{threat_level}{Perceived threat level of the individual (character).}
  \item{flee}{Whether the individual was fleeing (character).}
  \item{body_camera}{Whether the officer was wearing a body camera (logical).}
}
}
\source{
Washington Post Fatal Police Shootings database.
}
\usage{
data(police_shootings_tbl_df)
}
\description{
This dataset contains records of every fatal police shooting by an on-duty officer since January 1, 2015.
It includes information about the shooting incidents, the characteristics of the individuals involved, and details such as mental illness signs,
body camera usage, and more. This dataset is valuable for analyzing trends and patterns in fatal police shootings in the United States.
}
\details{
The dataset name has been changed to 'police_shootings_tbl_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the crimedatasets package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble, which is a modern version of a data frame in R.
The original content has not been modified in any way.
}
