% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-methods.R
\name{biomarker}
\alias{biomarker}
\alias{biomarker,integer,DualEndpoint,Samples-method}
\alias{biomarker-DualEndpoint}
\title{Get the Biomarker Levels for a Given Dual-Endpoint Model, Given Dose Levels and Samples}
\usage{
biomarker(xLevel, model, samples, ...)

\S4method{biomarker}{integer,DualEndpoint,Samples}(xLevel, model, samples, ...)
}
\arguments{
\item{xLevel}{(\code{integer})\cr the levels for the doses the patients have been
given w.r.t dose grid. See \code{\link{Data}} for more details.}

\item{model}{(\code{DualEndpoint})\cr the model.}

\item{samples}{(\code{Samples})\cr the samples of model's parameters that store
the value of biomarker levels for all doses on the dose grid.}

\item{...}{not used.}
}
\value{
The biomarker levels.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
This function simply returns a specific columns (with the indices equal
to \code{xLevel}) of the biomarker samples matrix, which is included in the the
\code{samples} object.
}
\section{Functions}{
\itemize{
\item \code{biomarker(xLevel = integer, model = DualEndpoint, samples = Samples)}: 

}}
\examples{
# Create the data.
my_data <- DataDual(
  x = c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10, 20, 20, 20, 40, 40, 40, 50, 50, 50),
  y = c(0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1),
  ID = 1:17,
  cohort = c(
    1L,
    2L,
    3L,
    4L,
    5L,
    6L,
    6L,
    6L,
    7L,
    7L,
    7L,
    8L,
    8L,
    8L,
    9L,
    9L,
    9L
  ),
  w = c(
    0.31,
    0.42,
    0.59,
    0.45,
    0.6,
    0.7,
    0.55,
    0.6,
    0.52,
    0.54,
    0.56,
    0.43,
    0.41,
    0.39,
    0.34,
    0.38,
    0.21
  ),
  doseGrid = c(0.1, 0.5, 1.5, 3, 6, seq(from = 10, to = 80, by = 2))
)

# Initialize the Dual-Endpoint model (in this case RW1).
my_model <- DualEndpointRW(
  mean = c(0, 1),
  cov = matrix(c(1, 0, 0, 1), nrow = 2),
  sigma2betaW = 0.01,
  sigma2W = c(a = 0.1, b = 0.1),
  rho = c(a = 1, b = 1),
  rw1 = TRUE
)

# Set-up some MCMC parameters and generate samples from the posterior.
my_options <- McmcOptions(
  burnin = 100,
  step = 2,
  samples = 500
)
my_samples <- mcmc(my_data, my_model, my_options)

# Obtain the biomarker levels (samples) for the second dose from the dose grid,
# which is 0.5.
biomarker(
  xLevel = 2L,
  model = my_model,
  samples = my_samples
)
}
