% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Backfill-class.R
\docType{class}
\name{OpeningAll-class}
\alias{OpeningAll-class}
\alias{.OpeningAll}
\alias{OpeningAll}
\alias{.DefaultOpeningAll}
\title{\code{OpeningAll}}
\usage{
OpeningAll(...)

.DefaultOpeningAll()
}
\arguments{
\item{...}{(\code{Opening})
opening objects to combine with AND logic.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{OpeningAll}} combines multiple \code{\link{Opening}} objects using AND logic.
A backfill cohort is opened only if ALL opening criteria in the list
are satisfied. This can also be created using the \code{&} operator.
}
\section{Slots}{

\describe{
\item{\code{open_list}}{(\code{list})
a list of \code{\link{Opening}} objects to be combined with AND logic.}
}}

\note{
Typically, end users will not use the \code{.DefaultOpeningAll()} function.
}
\examples{
# Create two opening criteria
opening1 <- OpeningMinDose(min_dose = 10)
opening2 <- OpeningMinCohorts(min_cohorts = 3)

# Combine them with AND logic: both must be satisfied
opening_all <- OpeningAll(opening1, opening2)
print(opening_all)

# Alternative: use the & operator
opening_all_alt <- opening1 & opening2
print(opening_all_alt)
}
\seealso{
\code{\link{Opening}}, \code{\link{OpeningAny}}, \code{\link{OpeningList}}.
}
