% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_design.R
\name{h_determine_dlts}
\alias{h_determine_dlts}
\title{Helper function to determine the dlts including first separate and placebo
condition}
\usage{
h_determine_dlts(
  data,
  dose,
  prob,
  prob_placebo = 0,
  prob_response = 0,
  prob_response_placebo = 0,
  cohort_size,
  cohort_size_placebo = 0,
  dose_grid,
  first_separate
)
}
\arguments{
\item{data}{(\code{Data})\cr what data to start from.}

\item{dose}{(\code{number})\cr current dose.}

\item{prob}{(\code{number})\cr defines the true probability for a DLT at the dose.}

\item{prob_placebo}{(\code{number})\cr defines the true probability for a DLT at a placebo condition.}

\item{prob_response}{(\code{number})\cr defines the true probability for a response at the dose.}

\item{prob_response_placebo}{(\code{number})\cr defines the true probability for a response at a placebo condition.}

\item{cohort_size}{(\code{number})\cr the cohort size to use.}

\item{cohort_size_placebo}{(\code{number})\cr the cohort size to use for placebo condition.}

\item{dose_grid}{(\code{numeric})\cr the dose_grid as specified by the user.}

\item{first_separate}{(\code{flag})\cr whether the first patient is enrolled separately.}
}
\value{
updated data object
}
\description{
Helper function to determine the dlts including first separate and placebo
condition
}
\keyword{internal}
