% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.crossnma.R
\name{plot.crossnma}
\alias{plot.crossnma}
\title{Trace plot of MCMC output}
\usage{
\method{plot}{crossnma}(x, ...)
}
\arguments{
\item{x}{An object generated by \code{\link{crossnma}}.}

\item{\dots}{Additional arguments (passed on to
\code{\link[coda]{traceplot}})}
}
\value{
No return value (plot function).
}
\description{
Produces a separate plot for each parameter in the JAGS model. Each
plot shows iterations vs sampled values.
}
\examples{
\dontrun{
# We conduct a network meta-analysis assuming a random-effects
# model.
# The data comes from randomized-controlled trials and
# non-randomized studies (combined naively)
head(ipddata) # participant-level data
stddata # study-level data

# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")

# Fit JAGS model
set.seed(1909)
fit <- crossnma(mod)

# Trace plot of model parameters
plot(fit)
}

}
\seealso{
\code{\link{crossnma}}, \code{\link[coda]{traceplot}}
}
\author{
Tasnim Hamza \email{hamza.a.tasnim@gmail.com}
}
\keyword{hplot}
