% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_small_trees.R
\name{remove_small_trees}
\alias{remove_small_trees}
\alias{remove_small_trees,data.frame-method}
\alias{remove_small_trees,LAS-method}
\alias{remove_small_trees,LAScatalog-method}
\title{Remove small clusters from segmented point cloud}
\usage{
remove_small_trees(
  point_cloud,
  min_radius = 1,
  min_height = -Inf,
  crown_id_column_name = "crown_id"
)

\S4method{remove_small_trees}{data.frame}(
  point_cloud,
  min_radius = 1,
  min_height = -Inf,
  crown_id_column_name = "crown_id"
)

\S4method{remove_small_trees}{LAS}(
  point_cloud,
  min_radius = 1,
  min_height = -Inf,
  crown_id_column_name = "crown_id"
)

\S4method{remove_small_trees}{LAScatalog}(
  point_cloud,
  min_radius = 1,
  min_height = -Inf,
  crown_id_column_name = "crown_id"
)
}
\arguments{
\item{point_cloud}{a point cloud, either as data.frame/data.table, or as
lidR::LAS object.}

\item{min_radius}{(Numeric >= 0) the threshold for crown radius, below which trees
will be removed}

\item{min_height}{(Numeric) the threshold for crown height, below which trees
will be removed. Works only if las is normalized.}

\item{crown_id_column_name}{the name of the column in which the id of the
crown is saved}
}
\value{
lidR LAS
}
\description{
The function takes a point cloud in which trees were segmented, and removes
tree clusters that are smaller than a certain radius or a certain height
}
\section{Functions}{
\itemize{
\item \code{remove_small_trees(data.frame)}: removes small tree clusters in a segmented
\link[lidR:LAS-class]{LAS object}.

\item \code{remove_small_trees(LAS)}: removes small tree clusters in a segmented
\link[lidR:LAS-class]{LAS object}.

\item \code{remove_small_trees(LAScatalog)}: removes small tree clusters in a segmented
\link[lidR:LAScatalog-class]{LAScatalog}.

}}
\section{Details}{

returns the same las object that was given as input, but with
altered crown id's. Trees that are considered too small have their crown id
set to NA, and all other crown id's are re-assigned so that they are
without gaps
}

