% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_sponsorType.R
\name{f.sponsorType}
\alias{f.sponsorType}
\title{Calculate type of sponsor of a study}
\usage{
f.sponsorType(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and `.sponsorType`, which is
a factor with levels `for profit`, `not for profit`, `mixed` (not and for
profit sponsors) or `other`.
}
\description{
Trial concept calculated: type or class of the sponsor(s) of the study.
No specific field is available in ISRCTN; thus, sponsor type is set to
`other`. Note: If several sponsors, sponsor type is deemed `mixed`
\emph{if there is both, a commercial and a non-commercial sponsor(s)}.
}
\examples{
# fields needed
f.sponsorType()

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.sponsorType",
  con = dbc)
trialsDf

}
