% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure-APIs.R
\name{get_demographic_exposure_prediction}
\alias{get_demographic_exposure_prediction}
\title{Get demographic exposure prediction data}
\usage{
get_demographic_exposure_prediction(
  DTXSID = NULL,
  API_key = NULL,
  Server = exposure_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some "progress report" should be given.}
}
\value{
A data.table of demographic exposure prediction data.
}
\description{
Get demographic exposure prediction data
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull general exposure prediction data for BPA
bpa <- get_demographic_exposure_prediction(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
