% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cmfit.R
\name{plot.cmfit}
\alias{plot.cmfit}
\title{Plot cmfit objects}
\usage{
\method{plot}{cmfit}(
  x,
  plotCI = TRUE,
  CI.level = 0.95,
  histogram = TRUE,
  add = FALSE,
  monthlabs = FALSE,
  nreps = 5000,
  hazcolor = "black",
  alpha = 0.3,
  ymax = NULL,
  prediction = NULL,
  yaxt = par()$yaxt,
  ...
)
}
\arguments{
\item{x}{a cmfit object}

\item{plotCI}{whether confidence intervals should also be drawn.}

\item{CI.level}{confidence level (default 0.95) for CIs (if CI is TRUE)}

\item{histogram}{boolean dictating whether a histogram of actual mortalities will be included in the plot}

\item{add}{boolean dictating whether the plot will be added to an existing plot}

\item{monthlabs}{whether or not to label the x-axis with months - suitable for (common) annual seasonal data.
If FALSE, labels are numeric within the period [0,1]}

\item{nreps}{number of samples from parameter estimates for confidence intervals (see \code{\link{predict.cmfit}})}

\item{hazcolor}{color of lines for hazard function and confidence intervals}

\item{alpha}{transparency of confidence interval polygon}

\item{ymax}{maximum value for the y-axis - can be useful for scaling purposes}

\item{prediction}{an optional \code{\link{predict.cmfit}} object- otherwise the function will estimate this every 
time which can be a bit slow.}

\item{yaxt}{location for y-axis label}

\item{...}{additional parameters to \code{\link{hist}} (e.g., number of breaks)}
}
\value{
a plot comparing the estimated mortality curve (based on parameter estimates)
and the actual results (as a histogram).
}
\description{
Plot cmfit objects
}
\examples{
# Simulate data
T.morts1 <- simulate_cycloSurv(1000, period = 365, 
                             meanhazard = 0.3 / 365, 
                             peaks = c(0.25 * 365, 0.75 * 365), 
                             durations = c(0.3 * 365, 0.1 * 365), 
                             weights = c(0.7,0.3), 
                             plotme = FALSE)

# Estimate simulated data
fits <- fit_cyclomort(T.morts1, n.seasons = 2)
fits

# Plot results
plot(fits, nreps = 1000, monthlabs = TRUE)
# NB: `nreps` is for the bootstrap of the confidence interval 
# The default (5000) is slower but smoother

# Actual parameter values from simulated data
attributes(T.morts1)
}
\seealso{
predict.cmfit
}
