% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_linear.R
\name{gammamix}
\alias{gammamix}
\alias{rgammamix}
\alias{pgammamix}
\alias{dgammamix}
\alias{qgammamix}
\title{Density, Distribution, Quantiles and Random Number Generation for the mixed gamma
distribution}
\usage{
rgammamix(n, shape, rate = 1, scale = 1/rate, prop)

dgammamix(x, shape, rate = 1, scale = 1/rate, prop)

pgammamix(q, shape, rate = 1, scale = 1/rate, prop)

qgammamix(p, shape, rate = 1, scale = 1/rate, prop)
}
\arguments{
\item{n}{\link[base]{integer} value, the number of random samples to be
generated with \code{rgammamix()}.}

\item{shape}{\link[base]{numeric} \link[base]{vector} holding the shape parameter
of the components.}

\item{rate}{\link[base]{numeric} \link[base]{vector} an alternative way to specify the scale
(\code{scale = 1 / rate}).}

\item{scale}{\link[base]{numeric} \link[base]{vector} holding the scale parameter
of the components.}

\item{prop}{\link[base]{numeric} \link[base]{vector}, holding the mixing proportions
of the components.}

\item{x}{\link[base]{numeric} \link[base]{vector} giving the points where
the density function is evaluated.}

\item{q}{\link[base]{numeric} \link[base]{vector} giving the quantiles where
the distribution function is evaluated.}

\item{p}{\link[base]{numeric} \link[base]{vector} giving the probabilities where
the quantile function is evaluated.}
}
\value{
\itemize{
\item \code{dgammamix()} gives a \link[base]{vector} of length \code{length(x)}
 containing the density at \code{x}.
\item \code{pgammamix()} gives a
\link[base]{vector} of length \code{length(q)} containing
the distribution function at the corresponding values of \code{q}.
\item \code{qgammamix()} gives a \link[base]{vector} of length \code{length(p)}
containing the quantiles at the corresponding values of \code{p}.
\item \code{rgammamix()} generates a \link[base]{vector} of length \code{n}
containing the random samples.
}
}
\description{
The number of components in the mixed gamma distribution is specified by the length
of the parameter vectors. The quantiles are numerically obtained from the distribution function using
monotone cubic splines.
}
\examples{

rgammamix(10, shape = c(1, 3, 7), scale = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))

dgammamix(c(0, 2, 1), shape = c(1, 3), rate = c(2, 2), prop = c(0.6, 0.4))

prob <- pgammamix(c(0.1, 7), shape = c(1, 3, 7), scale = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))
prob
qgammamix(prob, shape = c(1, 3, 7), scale = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))

}
