% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{czso_get_table}
\alias{czso_get_table}
\title{Retrieve and read dataset from CZSO}
\usage{
czso_get_table(
  dataset_id,
  dest_dir = NULL,
  force_redownload = FALSE,
  resource_num = 1
)
}
\arguments{
\item{dataset_id}{a character. Found in the czso_id column of data frame returned by \code{get_catalogue()}.}

\item{dest_dir}{character. Directory in which downloaded files will be stored.
If left unset, will use the \code{czso.dest_dir} option if the option is set, and \code{tempdir()} otherwise. Will be created if it does not exist.}

\item{force_redownload}{integer. Whether to redownload data source file even if already cached. Defaults to FALSE.}

\item{resource_num}{integer. Order of resource in resource list for the given dataset. Defaults to 1, the normal value for CZSO datasets.}
}
\value{
a \link[tibble:tibble-package]{tibble}, or vector of file paths if file is not CSV or if
there are multiple files in the dataset.
See Details on the columns contained in the tibble
}
\description{
Downloads and reads dataset identified by \code{dataset_id}.
Unzips if necessary, but only loads CSV files, otherwise returns the path to the downloaded file.
Converts types of columns where known, e.g. value columns to numeric.
}
\details{
\subsection{Structure of the output tibble}{

CZSO provides its open data as tidy data, so each row only contains one value
in the \code{hodnota} column and the remaining columns give details on how
that value is defined. See "Included columns" below on how these work.
}

\subsection{Data types}{

The schema of the dataset is not yet used, so some columns may be mistyped and are by default returned as character vectors.
}

\subsection{Included columns}{

The range of columns present in the output varies from one dataset to another,
so the package does not attempt to provide English-language names for
the known subset, as that would result in a jumble of Czenglish.

Instead, here is a guide to some of the common column names you will encounter:
\itemize{
\item \code{idhod}: a unique ID of the value in the CZSO database. This does not allow
you to link to any other (meta)data as far as I know, but it does provide unique
identification should you need it.
\item \code{hodnota}: the value.
\item \code{stapro_kod}: code of the statistic/indicator/variable as listed.
in the SMS UKAZ register (https://www.czso.cz/csu/czso/statistical-variables-indicators);
this one has Czech-English documentation - access this by clicking the UK flag top right.
You can also get a data table with the definitions, if you search for \code{"statistické proměnné"} in
the \code{title} field of the catalogue. Last I checked, the ID of this table was \code{"990124-17"}.
\item \code{rok} denotes year as YYYY.
\item \code{ctvrtleti} denotes quarter if available.
}

Other metadata will come in the form \verb{\{variable\}_[txt|cis|kod]}. The \verb{_txt}
column holds the Czech text name for the category. The \verb{_cis} column holds the
ID of the codelist (register) you need to decode the code in \verb{_kod}.
The English codelists are at http://apl.czso.cz/iSMS/en/cislist.jsp,
Czech ones at http://apl.czso.cz/iSMS/cs/cislist.jsp.
You can find the Czech-language codelists in the catalogue retrieved with
\code{czso_get_catalogue()}, where their IDs begin with \code{"cis"} followed by the number; the English ones can also be retrieved from
the link above using a permalink URL.

More conveniently, you can use the \code{czso_get_codelist()} function to retrieve the codelist.

Units are denoted in a separate column.

A helper on common breakdowns with their associated columns:
\itemize{
\item \code{uzemi}: territory
\item \code{vek}: age
\item \code{pohlavi}: gender
}

\code{NA}s in "breakdown" columns (e.g. gender or age) denote the total.
}
}
\note{
Do not use this for harvesting datasets from CZSO en masse.
}
\examples{
\donttest{
czso_get_table("110080")
}
}
\seealso{
Other Core workflow: 
\code{\link{czso_filter_catalogue}()},
\code{\link{czso_get_catalogue}()},
\code{\link{czso_get_codelist}()}
}
\concept{Core workflow}
