% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clu_kmeans.R
\name{cluster_kmeans}
\alias{cluster_kmeans}
\title{k-means}
\usage{
cluster_kmeans(k = 1)
}
\arguments{
\item{k}{the number of clusters to form.}
}
\value{
returns a k-means object.
}
\description{
k-means clustering using \code{stats::kmeans}.
}
\details{
Partitions data into k clusters minimizing within‑cluster sum of squares. The intrinsic
quality metric returned is the total within‑cluster SSE (lower is better).
}
\examples{
# setup clustering
model <- cluster_kmeans(k=3)

#load dataset
data(iris)

# build model
model <- fit(model, iris[,1:4])
clu <- cluster(model, iris[,1:4])
table(clu)

# evaluate model using external metric
eval <- evaluate(model, clu, iris$Species)
eval
}
\references{
MacQueen, J. (1967). Some Methods for classification and Analysis of Multivariate Observations.
Lloyd, S. (1982). Least squares quantization in PCM.
}
