% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.pcoa.plot.r
\name{gl.pcoa.plot}
\alias{gl.pcoa.plot}
\title{Bivariate or trivariate plot of the results of an ordination generated
 using gl.pcoa()}
\usage{
gl.pcoa.plot(
  glPca,
  x,
  scale = FALSE,
  ellipse = FALSE,
  plevel = 0.95,
  pop.labels = "pop",
  interactive = FALSE,
  as.pop = NULL,
  hadjust = 1.5,
  vadjust = 1,
  xaxis = 1,
  yaxis = 2,
  zaxis = NULL,
  pt.size = 2,
  pt.colors = NULL,
  pt.shapes = NULL,
  label.size = 1,
  axis.label.size = 1.5,
  plot.file = NULL,
  plot.dir = NULL,
  verbose = NULL
)
}
\arguments{
\item{glPca}{Name of the PCA or PCoA object containing the factor scores and
eigenvalues [required].}

\item{x}{Name of the genlight object or fd object containing the SNP
genotypes or Tag P/A (SilicoDArT) genotypes [required to gain access to metadata].}

\item{scale}{If TRUE, scale the x and y axes in proportion to \% variation
explained [default FALSE].}

\item{ellipse}{If TRUE, display ellipses to encapsulate points for each
population [default FALSE].}

\item{plevel}{Value of the percentile for the ellipse to encapsulate points
for each population [default 0.95].}

\item{pop.labels}{How labels will be added to the plot
['none'|'pop'|'legend', default = 'pop'].}

\item{interactive}{If TRUE then the populations are plotted without labels,
mouse-over to identify points [default FALSE].}

\item{as.pop}{Assign another metric to represent populations for the plot
[default NULL].}

\item{hadjust}{Horizontal adjustment of label position in 2D plots
[default 1.5].}

\item{vadjust}{Vertical adjustment of label position in 2D plots [default 1].}

\item{xaxis}{Identify the x axis from those available in the ordination
(xaxis <= nfactors) [default 1].}

\item{yaxis}{Identify the y axis from those available in the ordination
(yaxis <= nfactors) [default 2].}

\item{zaxis}{Identify the z axis from those available in the ordination for a
3D plot (zaxis <= nfactors) [default NULL].}

\item{pt.size}{Specify the size of the displayed points [default 2].}

\item{pt.colors}{Optionally provide a vector of nPop colors
(run gl.select.colors() for color options) [default NULL].}

\item{pt.shapes}{Optionally provide a vector of nPop shapes
(run gl.select.shapes() for shape options) [default NULL].}

\item{label.size}{Specify the size of the point labels [default 1].}

\item{axis.label.size}{Specify the size of the displayed axis labels
[default 1.5].}

\item{plot.file}{Name for the RDS binary file to save (base name only, 
exclude extension) [default NULL].}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default 2 or as specified using gl.set.verbosity].}
}
\value{
returns no value (i.e. NULL)
}
\description{
This script takes output from the ordination generated by gl.pcoa() and plots
the individuals classified by population.
}
\details{
The factor scores are taken from the output of gl.pcoa() and the population
assignments are taken from from the original data file. In the bivariate
plots, the specimens are shown optionally with adjacent labels and enclosing
ellipses. Population labels on the plot are shuffled so as not to overlap
(using package \{directlabels\}).
This can be a bit clunky, as the labels may be some distance from the points
to which they refer, but it provides the opportunity for moving labels around
 using graphics software (e.g. Adobe Illustrator).
3D plotting is activated by specifying a zaxis.
Any pair or trio of axes can be specified from the ordination, provided they
are within the range of the nfactors value provided to gl.pcoa().
In the 2D plots, axes can be scaled to represent the proportion of variation
explained. In any case, the proportion of variation explained by each axis is
provided in the axis label.
Colors and shapes of the points can be altered by passing a vector of shapes
and/or a vector of colors. These vectors can be created with
gl.select.shapes() and gl.select.colors() and passed to this script using the
 pt.shapes and pt.colors parameters.
Points displayed in the ordination can be identified if the option
 interactive=TRUE is chosen, in which case the resultant plot is ggplotly()
 friendly. Identification of points is by moving the mouse over them. Refer
 to the plotly package for further information.
The interactive option is automatically enabled for 3D plotting.

If a plot.file is given, the ggplot arising from this function is saved as an "RDS" 
binary file using saveRDS(); can be reloaded with readRDS(). A file name must be 
specified for the plot to be saved.
If a plot directory (plot.dir) is specified, the ggplot binary is saved to that
 directory; otherwise to the tempdir().
}
\examples{
 test <- gl.pcoa(platypus.gl)
 gl.pcoa.plot(glPca = test, x = platypus.gl)
\donttest{
# SET UP DATASET
gl <- testset.gl
levels(pop(gl))<-c(rep('Coast',5),rep('Cooper',3),rep('Coast',5),
rep('MDB',8),rep('Coast',7),'Em.subglobosa','Em.victoriae')
# RUN PCA
pca<-gl.pcoa(gl,nfactors=5)
# VARIOUS EXAMPLES
gl.pcoa.plot(pca, gl, ellipse=TRUE, plevel=0.95, pop.labels='pop', 
axis.label.size=1, hadjust=1.5,vadjust=1)
gl.pcoa.plot(pca, gl, ellipse=TRUE, plevel=0.99, pop.labels='legend', 
axis.label.size=1)
gl.pcoa.plot(pca, gl, ellipse=TRUE, plevel=0.99, pop.labels='legend', 
axis.label.size=1.5,scale=TRUE)
gl.pcoa.plot(pca, gl, ellipse=TRUE, axis.label.size=1.2, xaxis=1, yaxis=3, 
scale=TRUE)
gl.pcoa.plot(pca, gl, pop.labels='none',scale=TRUE)
gl.pcoa.plot(pca, gl, axis.label.size=1.2, interactive=TRUE)
gl.pcoa.plot(pca, gl, ellipse=TRUE, plevel=0.99, xaxis=1, yaxis=2, zaxis=3)
# COLOR AND SHAPE ADJUSTMENTS
shp <- gl.select.shapes(select=c(16,17,17,0,2))
col <- gl.select.colors(library='brewer',palette='Spectral',ncolors=11,
select=c(1,9,3,11,11))
gl.pcoa.plot(pca, gl, ellipse=TRUE, plevel=0.95, pop.labels='pop', 
pt.colors=col, pt.shapes=shp, axis.label.size=1, hadjust=1.5,vadjust=1)
gl.pcoa.plot(pca, gl, ellipse=TRUE, plevel=0.99, pop.labels='legend',
 pt.colors=col, pt.shapes=shp, axis.label.size=1)
# DISTANCE MATRIX
 D <- gl.dist.ind(gl)
 pco <- gl.pcoa(D)
 gl.pcoa.plot(pco,gl,ellipse=TRUE)
 }
}
\seealso{
\code{\link{gl.pcoa}}
}
\author{
Custodian: Arthur Georges -- Post to
 \url{https://groups.google.com/d/forum/dartr}
}
\concept{Exploration/visualisation functions}
