% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_manipulation.R
\name{last_date}
\alias{last_date}
\title{Dernière date non NA}
\usage{
last_date(series)
}
\arguments{
\item{series}{un objet ts unidimensionnel conforme aux règles de assert_ts}
}
\value{
En sortie, la fonction retourne un objet au format \code{date_ts}
(\code{AAAA}, \code{c(AAAA, MM)} ou \code{c(AAAA, TT)})
}
\description{
Cette fonction calcule la dernière date pour laquelle l'objet
\code{series} ne vaut pas NA.
}
\details{
La date retournée en output est au format \code{date_ts}. Si l'objet
\code{series} ne contient que des NAs, la fonction retourne une erreur.
}
\examples{

ts1 <- ts(c(NA, NA, NA, 1:10, NA), start = 2000, frequency = 12L)
ts2 <- ts(c(1:10), start = 2020, frequency = 4L)

stats::end(ts1)
last_date(ts1)

stats::end(ts2)
last_date(ts2)

}
\seealso{
\code{first_date}
}
