% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-class-model-priors.R
\name{dcmprior}
\alias{dcmprior}
\title{S7 prior class}
\usage{
dcmprior(
  distribution = character(0),
  type = NA_character_,
  coefficient = NA_character_,
  lower_bound = NA_real_,
  upper_bound = NA_real_
)
}
\arguments{
\item{distribution}{A distribution statement for the prior
(e.g., \code{normal(0, 2)}). For a complete list of available distributions, see
the \emph{Stan} documentation at \url{https://mc-stan.org/docs/}.}

\item{type}{The type of parameter to apply the prior to. Parameter types will
vary by model. Use \code{\link[=get_parameters]{get_parameters()}} to see list of possible types for
the chosen model.}

\item{coefficient}{Name of a specific parameter within the defined parameter
type. If \code{NA} (the default), the prior is applied to all parameters within
the type.}

\item{lower_bound}{Optional. The lower bound where the distribution should be
truncated.}

\item{upper_bound}{Optional. The upper bound where the distribution should be
truncated.}
}
\value{
A \code{dcmprior} object.
}
\description{
The \code{dcmprior} constructor is exported to facilitate the defining
of methods in other packages. We do not expect or recommend calling this
function directly. Rather, to create a model specification, one should use
\code{\link[=prior]{prior()}} or \code{\link[=default_dcm_priors]{default_dcm_priors()}}.
}
\examples{
dcmprior(
  distribution = "normal(0, 1)",
  type = "intercept"
)
}
\seealso{
\code{\link[=prior]{prior()}}, \code{\link[=default_dcm_priors]{default_dcm_priors()}}.
}
