#' @importFrom VMDecomp vmd
#' @importFrom forecast nnetar forecast
#' @importFrom utils head tail
#' @importFrom nnfor elm
#' @importFrom graphics plot
#' @importFrom stats as.ts ts
#' @export
#'

vmdELM <- function(data, stepahead=10, nIMF=4, alpha=2000, tau=0, D=FALSE)
{
  data <- ts(data)
  data<- as.vector(data)
  v<- vmd(data , alpha=2000, tau=0, K=nIMF, DC=D, init=1, tol = 1e-6)
  AllIMF<-v$u
  data_trn <- ts(head(data, round(length(data) - stepahead)))
  data_test <- ts(tail(data, stepahead))
  IMF_trn <- AllIMF[-c(((length(data) - stepahead) + 1):length(data)),
  ]
  Fcast_AllIMF <- NULL
  for (AllIMF in 1:(ncol(IMF_trn))) {
    IndIMF <- NULL
    IndIMF <- IMF_trn[, AllIMF]
    vmdELMFit <- nnfor::elm(as.ts(IndIMF))
    vmdELM_fcast = forecast::forecast(vmdELMFit, h = stepahead)
    vmdELM_fcast_Mean = vmdELM_fcast$mean
    Fcast_AllIMF <- cbind(Fcast_AllIMF, as.matrix(vmdELM_fcast_Mean))
  }
  FinalvmdELM_fcast <- ts(rowSums(Fcast_AllIMF, na.rm = T))
  MAE_vmdELM = mean(abs(data_test - FinalvmdELM_fcast))
  MAPE_vmdELM = mean(abs(data_test - FinalvmdELM_fcast)/data_test)
  RMSE_vmdELM = sqrt(mean((data_test - FinalvmdELM_fcast)^2))
  return(list(AllIMF = AllIMF, data_test = data_test,
              AllIMF_forecast = Fcast_AllIMF, FinalvmdELM_forecast = FinalvmdELM_fcast,
              MAE_vmdELM = MAE_vmdELM, MAPE_vmdELM = MAPE_vmdELM,
              RMSE_vmdELM = RMSE_vmdELM ))
}
