% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappa.R
\name{kappa,eclairs-method}
\alias{kappa,eclairs-method}
\title{Compute condition number}
\usage{
\S4method{kappa}{eclairs}(z, lambda = NULL)
}
\arguments{
\item{z}{\code{eclairs()} decomposition}

\item{lambda}{specify lambda to override value from \code{z}}
}
\value{
condition number of the correlation matrix.  If \code{z} is a covariance matrix, kappa is only computed for the correlation component
}
\description{
Compute condition number of matrix from \code{eclairs} decomposition
}
\examples{
library(Rfast)

n <- 800 # number of samples
p <- 200 # number of features

# create correlation matrix
Sigma <- autocorr.mat(p, .9)

# draw data from correlation matrix Sigma
Y <- rmvnorm(n, rep(0, p), sigma = Sigma * 5.1, seed = 1)
rownames(Y) <- paste0("sample_", seq(n))
colnames(Y) <- paste0("gene_", seq(p))

# eclairs decomposition
ecl <- eclairs(Y, compute = "correlation")

# compute condition number
kappa(ecl)

}
