% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{add_shuffle}
\alias{add_shuffle}
\title{De-identification via random sampling}
\usage{
add_shuffle(object, ..., limit = 0)
}
\arguments{
\item{object}{Either a \code{data.frame}, \code{tibble}, or existing \code{DeidentList} pipeline.}

\item{...}{variables to be transformed.}

\item{limit}{integer - the minimum number of observations a variable needs to
have for shuffling to be performed.  If the variable has length less than \code{limit}
values are replaced with \code{NA}s.}
}
\value{
A 'DeidentList' representing the untrained transformation pipeline.
The object contains fields:
\itemize{
\item \code{deident_methods} a list of each step in the pipeline (consisting of \code{variables} and \code{method})
}

and methods:
\itemize{
\item \code{mutate} apply the pipeline to a new data set
\item \code{to_yaml} serialize the pipeline to a '.yml' file
}
}
\description{
\code{add_shuffle()} adds a shuffling step to a transformation pipeline.
When ran as a transformation, each specified variable undergoes a random sample without
replacement so that summary metrics  on a single variable are unchanged, but
inter-variable metrics are rendered spurious.
}
\examples{

# Basic usage; 
pipe.shuffle <- add_shuffle(ShiftsWorked, Employee)
pipe.shuffle$mutate(ShiftsWorked)

pipe.shuffle.limit <- add_shuffle(ShiftsWorked, Employee, limit=1)
pipe.shuffle.limit$mutate(ShiftsWorked)

}
\seealso{
\code{\link[=add_group]{add_group()}} for usage under aggregation
}
\keyword{API}
