% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{nestedFunBuilder}
\alias{nestedFunBuilder}
\title{Create nested data structures with optional function application}
\usage{
nestedFunBuilder(data, ..., .fun = identity, .funArgs = list())
}
\arguments{
\item{data}{a data frame, list, tibble or object coercible by
\code{\link{as.data.frame}} to a data frame containing the variables whose
names are given in the factor arguments.}

\item{...}{character strings specifying the names of grouping variables
(factors) in \code{data}. The nesting order follows the argument order.}

\item{.fun}{function to apply to each final data subset. Default is
\code{identity} which returns the data subset unchanged.}

\item{.funArgs}{list of additional arguments to pass to \code{.fun}.}
}
\value{
A nested list structure where each level corresponds to a factor
level. If \code{.fun = identity}, returns data subsets. Otherwise, returns
the result of applying \code{.fun} to each subset.
}
\description{
Creates nested list structures by grouping data according to specified factors
and optionally applying a function to each final subset. This is the main
function for creating hierarchical data structures for analysis.
}
\details{
The function performs the following steps:
\itemize{
  \item Validates that all specified factors exist in the data
  \item Warns about missing factors and removes them from processing
  \item Creates nested subsets using the specified factors
  \item Applies the specified function to each final subset
}
}
\examples{
\dontrun{
# Create nested data structure
nested_data <- nestedFunBuilder(iris, "Species", "Sepal.Length > 5")

# Apply function to each subset
means <- nestedFunBuilder(iris, "Species",
  .fun = function(data) mean(data$Sepal.Length)
)

# Multiple factors with function
results <- nestedFunBuilder(mydata, "site", "species", "treatment",
  .fun = myAnalysisFunction,
  .funArgs = list(method = "robust")
)
}

}
\keyword{internal}
