% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_regression.R
\name{logreg}
\alias{logreg}
\title{Binary Logistic Regression Table with Univariable and Multivariable Analysis}
\arguments{
\item{data}{A data frame containing the outcome and predictor variables.}

\item{outcome}{Name of the binary outcome variable (character).}

\item{predictors}{Character vector of predictor variable names.}

\item{report}{Logical; if TRUE, prints an automatic textual interpretation of multivariable results (default: FALSE).}
}
\value{
A \code{flextable} summarizing univariable and multivariable logistic regression results, including ORs, 95\% CI, and p-values.
}
\description{
Fits univariable and multivariable logistic regression models for a binary outcome,
summarizing odds ratios (ORs), 95\% confidence intervals, and p-values.
Factor predictors include reference levels in the table. Returns a formatted \code{flextable}
and optionally provides an automatic textual interpretation of results.
}
\examples{
logreg(data=medical_data(), outcome="case" ,
   predictors= c("age" ,  "parity" ,    "induced" ), report = TRUE)
}
