% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spiked_wishart.R
\name{multi_sample_spiked_wishart}
\alias{multi_sample_spiked_wishart}
\title{Compute means of each singular value and the mean Jacobian, see sample_spiked_wishart_and_jac}
\usage{
multi_sample_spiked_wishart(
  count,
  spiked_sd,
  num_observations,
  num_variables,
  population_sd = 1,
  num_eigs = 0
)
}
\arguments{
\item{count}{The number of samples to compute the mean of}

\item{spiked_sd}{The spiked standard deviations}

\item{num_observations}{The number of observations (aka samples or columns)}

\item{num_variables}{The number of variables (aka features or rows)}

\item{population_sd}{the standard deviation of all non-spiked components (num_variables - length(spiked_sd) of them)}

\item{num_eigs}{The number of eigenvalues to compute. If 0 compute all of them using dense matrix routines. If greater than zero, use sparse matrices and compute that many top eigenvalues.}
}
\value{
List with a vector of mean singular values of G where G is a random num_variables x num_observations matrix with iid columns from N(0, Sigma) where Sigma is diagonal with entries spiked_sd^2 and all the remaining are population_sd^2.
and also the mean Jacobian, where \verb{\[i,j\]} is the derivative of the ith singular value with respect to the jth spiked SD, and the
gradient of the population_sd parameter
}
\description{
Compute means of each singular value and the mean Jacobian, see sample_spiked_wishart_and_jac
}
\examples{
# Sample 10 times from the spiked Wishart distribution with (500, 100, 1, ..., 1) singular values
# and take the means of the singular values as well as derivatives (jacobian and pop_sd_grad)
mean_vals <- multi_sample_spiked_wishart(
    count = 10,
    spiked_sd = c(500, 100),
    num_observations = 10-1,
    num_variables = 1000,
    num_eigs = 3
)
mean_vals$singular_vals
mean_vals$jacobian
mean_vals$pop_sd_grad
}
