% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-deseats.R, R/class-s_semiarma.R
\name{bwidth,deseats-method}
\alias{bwidth,deseats-method}
\alias{bwidth,s_semiarma-method}
\title{Retrieve the Used Bandwidth from an Estimation Object}
\usage{
\S4method{bwidth}{deseats}(object)

\S4method{bwidth}{s_semiarma}(object)
}
\arguments{
\item{object}{an object either of class \code{"deseats"} or 
\code{"s_semiarma"}.}
}
\value{
A numeric vector of length one that represents the bandwidth used in the
smoothing procedure is returned.
}
\description{
If either \code{\link{deseats}} or \code{\link{s_semiarma}} are 
used to fit a model to time series data, this method retrieves 
the applied bandwidth from the output object.
}
\details{
When applying \code{\link{deseats}} or \code{link{s_semiarma}},
one approach is to let the functions automatically choose a 
bandwidth for locally weighted regression. Using this method,
the applied bandwidth can be retrieved.
}
\examples{
\donttest{
Xt <- log(EXPENDITURES)
smoothing_options <- set_options(order_poly = 3)
est <- deseats(Xt, smoothing_options = smoothing_options)
bwidth(est)
}

}
