% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-smoothing_options.R
\name{set_options}
\alias{set_options}
\title{Specification of Smoothing Options}
\usage{
set_options(
  order_poly = 1,
  season = NA_real_,
  kernel_fun = "epanechnikov",
  bwidth = NA_real_,
  boundary_method = "extend"
)
}
\arguments{
\item{order_poly}{the order of the local polynomials used for estimating the
smooth nonparametric trend; the default is \code{1}.}

\item{season}{the frequency of observations per time unit, for example per 
year; set to \code{12} for monthly data and to \code{4} for quarterly data
and so on; the default is \code{NA_real_}, which leads to an automated 
frequency selection for time series objects in smoothing functions; if 
the argument is set to \code{NA_real_} and the observations used for smoothing 
are not formatted as time series objects, the frequency \code{1} will be 
used.}

\item{kernel_fun}{the weighting function to consider; supported are four
second-order kernel functions with compact support on \eqn{[-1, 1]}; enter
\code{"uniform"} for the uniform kernel, \code{"epanechnikov"} for the 
Epanechnikov kernel, \code{"bisquare"} for the bisquare kernel or 
\code{"triweight"} for the triweight kernel; the default is 
\code{"epanechnikov"}.}

\item{bwidth}{a numeric value that indicates the relative bandwidth to 
consider in the smoothing process; the default is \code{NA}, which then
triggers a data-driven selection of an globally optimal bandwidth when
the output of this function is passed to a smoothing function.}

\item{boundary_method}{a single character value; it indicates, what bandwidth 
method to use at boundary points; for \code{"extend"}, the default, the 
smoothing window around boundary points will be extended towards the center of 
the data; for \code{"shorten"}, the window width will keep decreasing at 
boundary points when approaching the very first and the very last observation.}
}
\value{
The function returns an S4 object with the following elements (access via 
\code{@}):

\describe{
\item{order_poly}{identical to the input argument with that name; please see 
the description of that input argument.}
\item{season}{identical to the input argument with that name; please see 
the description of that input argument.}
\item{kernel_fun}{identical to the input argument with that name; please see 
the description of that input argument.}
\item{bwidth}{identical to the input argument with that name; please see 
the description of that input argument.}
\item{boundary_method}{identical to the input argument with that name; please 
see the description of that input argument.}
}
}
\description{
Set the smoothing specifications for locally weighted regression for
identifying the trend and the seasonality in an equidistant time series.
}
\details{
An object of class \code{"smoothing_options"} is created that contains 
all required information to conduct a locally weighted regression for 
decomposing a seasonal time series. The information include the order 
of the trend polynomials, the frequency of the observed series, the 
second-order kernel function to use in the weighting process, the 
(relative) bandwidth to employ, and the boundary method for the bandwidth.
}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
