\name{ols.interval}
\alias{ols.interval}
\title{Calculate Different Types of Intervals in a Linear Model}
\usage{
ols.interval(
  mod,
  data = list(),
  type = c("confidence", "prediction", "acceptance"),
  which.coef = "all",
  sig.level = 0.05,
  q = 0,
  dir = c("both", "left", "right"),
  xnew,
  details = FALSE
)
}
\arguments{
\item{mod}{linear model object generated by \code{ols()}.}

\item{data}{name of data frame to be specified if mod is a formula.}

\item{type}{string value indicating the type of interval to be calculated. Default is "confidence".}

\item{which.coef}{strings of variable name(s) or vector of indices indicating the coefficients in the linear model for which confidence or acceptance intervals should be calculated. By default all coefficients are selected. Ignored for prediction intervals.}

\item{sig.level}{significance level.}

\item{q}{value against which null hypothesis is tested. Only to be specified if type = "acceptance".}

\item{dir}{direction of the alternative hypothesis underlying the acceptance intervals. One sided confidence- and prediction intervals are not (yet) supported.}

\item{xnew}{(T x K) matrix of new values of the exogenous variables, at which interval should be calculated, where T is the number of exogenous data points at which intervals should be calculated K is the number of exogenous variables in the model If type = "prediction" then prediction intervals are calculated at xnew, if type = "confidence" then confidence intervals around the unknown true y-values are calculated at xnew (ak.a. confidence band). Ignored if type = "acceptance". In multiple regression models variable names must be specified.}

\item{details}{logical value indicating whether details (estimated standard deviations) should be printed out.}
}
\value{
A list object including:
\tabular{ll}{
\code{results} \tab interval borders (lower and upper) and center of interval (if \code{dir = "both"}).\cr
\code{std.err} \tab estimated standard deviations.\cr
\code{t.value} \tab critical t-value.\cr
}
}
\description{
Calculates different types of intervals in a linear model.
}
\examples{
fert.est <- ols(barley ~ phos + nit, data = log(data.fertilizer))
my.mat = cbind(x1 = log(c(6,3,9)), x2 = log(c(5,3,10)))

## 95\% CI for all parameters
ols.interval(fert.est)

## 95\% CI for intercept and beta2
ols.interval(fert.est, which.coef = c(1,3))

## 95\% CI around three true, constant y-values
ols.interval(fert.est, xnew = my.mat)

## AI for H0:beta1 = 0.5 and H0:beta2 = 0.5
ols.interval(fert.est, type = "acc", which.coef = c(2,3), q = 0.5)

## AI for H0:beta1 <= 0.5
ols.interval(fert.est, type = "acc", which.coef = 2, dir = "right", q = 0.5)

## PI (Textbook p. 285)
ols.interval(fert.est, type = "pred", xnew = c(x1 = log(29), x2 = log(120)), details = TRUE)

## Three PI
ols.interval(fert.est, type = "pred", xnew = my.mat, details = TRUE)

}
\concept{acceptance interval}
\concept{confidence interval}
\concept{linear model}
\concept{prediction interval}
