% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standards.R
\name{standards_db}
\alias{standards_db}
\title{Export a standard setting database for use by the free 3DC application}
\usage{
standards_db(
  par.sts,
  file_name,
  standards,
  population = NULL,
  group_leader = "admin"
)
}
\arguments{
\item{par.sts}{an object containing parameters for the 3DC standard setting procedure produced by
\code{\link{standards_3dc}}}

\item{file_name}{name of the exported database file}

\item{standards}{vector of 1 or more standards. In case there are multiple test forms and
they should use different performance standards, a list of such vectors. 
The names of this list should correspond to the names of the testforms}

\item{population}{optional, a data.frame with three columns: `booklet_id`,`booklet_score`,`n` (where n is a count)}

\item{group_leader}{login name of the group leader. The login password will always be `admin` 
but can be changed in the 3DC application}
}
\description{
This function creates an export (an sqlite database file) which can be used by the 3DC application. This is a free application with which
a standard setting session can be facilitated through a LAN network using the Chrome browser.
The 3DC application can be downloaded from \href{https://cito.com/what-we-do/support/3dc}{3DC application download page}
}
