test_that("derive_counts recovers counts from sens, spec, prevalence", {
  res <- derive_counts(
    n = 105,
    sensitivity = 0.6,
    specificity = 0.893,
    prevalence = 0.733
  )

  expect_s3_class(res, "diagcounts")
  expect_equal(sum(unlist(res)), 105)
  expect_true(all(unlist(res) >= 0))
})

test_that("derive_counts errors when rounding causes infeasibility", {
  expect_error(
    derive_counts(
      n = 200,
      sensitivity = 0.75,
      ppv = 0.82,
      npv = 0.70
    ),
    "rounded counts do not sum to n"
  )
})


test_that("derive_counts errors with insufficient information", {
  expect_error(
    derive_counts(n = 100, sensitivity = 0.8),
    "At least three accuracy measures"
  )
})
