% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diario.R
\name{diario_get_reports}
\alias{diario_get_reports}
\title{Get reports of a specific project}
\usage{
diario_get_reports(project_id, limit = 50, order = "desc")
}
\arguments{
\item{project_id}{A valid non-empty string with the project ID.}

\item{limit}{An integer specifying the maximum number of reports to retrieve. Default is 50.}

\item{order}{A character string specifying the order of the reports (e.g., "asc" or "desc"). Default is "desc".}
}
\value{
A tibble containing the reports.
}
\description{
This function retrieves reports of a specific project with optional parameters for limit and order.
}
\examples{
\dontrun{
reports <- diario_get_reports("6717f864d163f517ae06e242", limit = 10, order = "asc")
}
}
