% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_tabulation.R
\name{explore_tabulation}
\alias{explore_tabulation}
\title{Interactively explore a tabulation of a phytosociological matrix}
\usage{
explore_tabulation(tab, palette = "Vik")
}
\arguments{
\item{tab}{A list as returned by the \code{\link[=tabulation]{tabulation()}} function.}

\item{palette}{A character with the name of the colour palette (one of
\code{\link[grDevices:palettes]{grDevices::hcl.pals()}} to be passed to \code{\link[grDevices:palettes]{grDevices::hcl.colors()}}. Defaults
to "Vik".}
}
\value{
Returns invisibly, although it prints taxa names on the console upon
the user click on the figure.
}
\description{
This function plots an interactive image of a tabulation.
}
\details{
The function explore.tabulation accepts an object returned by the
\code{\link[=tabulation]{tabulation()}} function, plotting a condensed image of the
respective tabulated matrix, permitting the user to click on the coloured
blocks and receive the respective list of taxa names on the console.
}
\examples{
# Getting the Taxus baccata forests data set
data(taxus_bin)
# Creating a group partition, as presented in the original article of
# the data set
groups <- rep(c(1, 2, 3), c(3, 11, 19))

# Removing taxa occurring in only one relevé in order to
# reproduce exactly the example in the original article of the data set
taxus_bin_wmt <- taxus_bin[rowSums(taxus_bin) > 1, ]

# Sorts the phytosociological table, putting exclusive taxa at the top and
# plots an image of it
tabul <- tabulation(
  m_bin = taxus_bin_wmt,
  p = groups,
  taxa_names = rownames(taxus_bin_wmt),
  plot_im = "normal",
  palette = "Zissou 1"
)

# This creates an interactive plot (where you can click)
if (interactive()) {
  explore_tabulation(tabul, palette = "Zissou 1")
}

}
\author{
Tiago Monteiro-Henriques. E-mail: \email{tmh.dev@icloud.com}.
}
