% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{muris_2008}
\alias{muris_2008}
\title{Muris et al. (2008) data}
\format{
A tibble with 70 rows and 6 variables.
}
\source{
\href{https://www.discovr.rocks/csv/muris_2008.csv}{www.discovr.rocks/csv/muris_2008.csv}
}
\usage{
muris_2008
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
Anxious people tend to interpret ambiguous information in a negative way. For example, being highly anxious myself,
if I overheard a student saying "Andy Field's lectures are really different" I would assume that \emph{different}
meant rubbish, but it could also mean 'refreshing' or 'innovative'. Muris, Huijding, Mayer, and Hameetman (2008)
addressed how these interpretational biases develop in children. Children imagined that they were astronauts who
had discovered a new planet. They were given scenarios about their time on the planet (e.g., \emph{On the street, you
encounter a spaceman. He has a toy handgun and he fires at you …}) and the child had to decide whether a positive
(\emph{You laugh: it is a water pistol and the weather is fine anyway}) or negative (\emph{Oops, this hurts! The pistol
produces a red beam which burns your skin!}) outcome occurred. After each response the child was told whether
their choice was correct. Half of the children were always told that the negative interpretation was correct,
and the reminder were told that the positive interpretation was correct.

Over 30 scenarios children were trained to interpret their experiences on the planet as negative or positive.
Muris et al. then measured interpretational biases in everyday life to see whether the training had created a
bias to interpret things negatively. In doing so, they could ascertain whether children might learn interpretational
biases through feedback (e.g., from parents).The data contains the following variables:
\itemize{
\item \strong{participant}: a number identifying he participant
\item \strong{age}: participant's age in years
\item \strong{gender}: self-reported gender of the participant
\item \strong{scared}: score on The Screen for Child Anxiety Related Disorders (SCARED)
\item \strong{training}: whether the child was assigned to positive interpretation training or negative interpretation training.
\item \strong{int_bias}: interpretation bias for everyday events
}
}
\references{
\itemize{
\item Muris, P., Huijding, J., Mayer, B., & Hameetman, M. (2008). A space odyssey: Experimental manipulation of threat perception and anxiety-related interpretation bias in children. \emph{Child Psychiatry and Human Development}, 39, 469–480. \doi{10.1007/s10578-008-0103-z}
}
}
\keyword{datasets}
