% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.R
\name{spline_cdf}
\alias{spline_cdf}
\title{Approximate density function, CDF, or quantile function on the interior of
provided quantiles by representing the distribution as a sum of a discrete
part at any duplicated \code{qs} and a continuous part for which the CDF is
estimated using a monotonic Hermite spline. See details for more.}
\usage{
spline_cdf(ps, qs, tail_dist, fn_type = c("d", "p", "q"), n_grid = 20)
}
\arguments{
\item{ps}{vector of probability levels}

\item{qs}{vector of quantile values corresponding to ps}

\item{tail_dist}{name of parametric distribution for the tails}

\item{fn_type}{the type of function that is requested: \code{"d"} for a PDF,
\code{"p"} for a CDF, or \code{"q"} for a quantile function.}

\item{n_grid}{grid size to use when augmenting the input \code{qs} to obtain a
finer grid of points along which we form a piecewise linear approximation
to the spline. \code{n_grid} evenly-spaced points are inserted between each
pair of consecutive values in \code{qs}. The default value is 20. This can
be set to \code{NULL}, in which case the piecewise linear approximation is not
used. This is not recommended if the \code{fn_type} is \code{"q"}.}
}
\value{
a function to evaluate the PDF, CDF, or quantile function.
}
\description{
Approximate density function, CDF, or quantile function on the interior of
provided quantiles by representing the distribution as a sum of a discrete
part at any duplicated \code{qs} and a continuous part for which the CDF is
estimated using a monotonic Hermite spline. See details for more.
}
\details{
The CDF of the continuous part of the distribution is estimated
using a monotonic degree 3 Hermite spline that interpolates the quantiles
after subtracting the discrete distribution and renormalizing. In theory,
an estimate of the quantile function could be obtained by directly inverting
this spline. However, in practice, we have observed that this can suffer from
numerical problems. Therefore, the default behavior of this function is to
evaluate the "stage 1" CDF estimate corresponding to discrete point masses
plus monotonic spline at a fine grid of points, and use the "stage 2" CDF
estimate that linearly interpolates these points with steps at any duplicated
q values. The quantile function estimate is obtained by inverting this
"stage 2" CDF estimate. When the distribution is continuous, we can obtain an
estimate of the PDF by differentiating the CDF estimate, resulting in a
discontinuous "histogram density". The size of the grid can be specified with
the \code{n_grid} argument. In settings where it is desirable to obtain a
continuous density function, the "stage 1" CDF estimate can be used by
setting \code{n_grid = NULL}.
}
