% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Math.R
\name{Math.dst}
\alias{Math.dst}
\title{Mathematical Transformations for Distributions}
\usage{
\method{Math}{dst}(x, ...)
}
\arguments{
\item{x}{A probability distribution object.}

\item{...}{Additional arguments passed to specific methods. For \code{log()},
you can specify \code{base} (defaults to \code{exp(1)} for natural log).}
}
\value{
A transformed distribution object.
}
\description{
Apply mathematical functions like \code{log()} and \code{exp()} to probability
distributions. If \code{X} is a random variable following a distribution,
these functions return the distribution of the transformed variable.
}
\details{
These S3 methods extend base R functions to work with distributions.
}
\section{Supported Functions}{

\describe{
\item{\code{log(x, base = exp(1))}}{Returns the distribution of \code{log(X)}.
The base can be specified (defaults to natural log). An error is returned
if the distribution has non-positive values as possible outcomes.}
\item{\code{log10(x)}}{Returns the distribution of \code{log10(X)}. Equivalent to
\code{log(x, base = 10)}.}
\item{\code{exp(x)}}{Returns the distribution of \code{exp(X)}.}
\item{\code{sqrt(x)}}{Returns the distribution of \code{sqrt(X)}. Equivalent to
\code{x^0.5}. Requires all values to be non-negative.}
}
}

\section{Power Operator}{

The power operator \code{^} also works with distributions (see \code{\link[=Ops.dst]{Ops.dst()}}).
When raising a distribution to a numeric power (e.g., \code{dst^2}), it uses
the relationship \code{X^a = exp(a * log(X))}, combining both exponential and
logarithmic transformations.
}

\examples{
# Logarithmic transformations
d <- distionary::dst_unif(1, 10)
log(d)              # Natural log
log(d, base = 10)   # Log base 10
log10(d)            # Also log base 10
sqrt(d)             # Square root of uniform

# Exponential transformation
d2 <- distionary::dst_norm(0, 1)
d3 <- distionary::dst_beta(5, 4)
exp(d2)             # Log-normal distribution
exp(d3)             # No simplification

# These can be combined
log(exp(d2))        # Returns back to normal distribution
log(exp(d3))        # Still returns d3.
5^(log(d3, base = 5)) # Still returns d3.
}
\seealso{
\itemize{
\item \code{\link[=Ops.dst]{Ops.dst()}} for the \code{^} operator and other arithmetic operations
\item \code{\link[=shift]{shift()}}, \code{\link[=multiply]{multiply()}}, \code{\link[=flip]{flip()}}, \code{\link[=invert]{invert()}} for linear transformations
}
}
