% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ops.R
\name{Ops.dst}
\alias{Ops.dst}
\title{Arithmetic Operations for Distributions}
\usage{
\method{Ops}{dst}(e1, e2)
}
\arguments{
\item{e1}{A probability distribution or numeric value.}

\item{e2}{A probability distribution or numeric value.}
}
\value{
A transformed distribution object.
}
\description{
Apply arithmetic operators to probability distributions. These operations
transform distributions in intuitive ways, treating them similarly to
numeric values.
}
\details{
These S3 methods extend arithmetic operators to work with distributions.
}
\section{Supported Operators}{

\describe{
\item{\code{d + a} or \code{a + d}}{Shifts the distribution by adding constant \code{a}.
Equivalent to \code{\link[=shift]{shift()}}.}
\item{\code{d - a}}{Shifts the distribution by subtracting constant \code{a}.
Equivalent to \code{shift(d, -a)}.}
\item{\code{-d}}{Flips the distribution (negation). Equivalent to \code{\link[=flip]{flip()}}.}
\item{\code{d * a} or \code{a * d}}{Scales the distribution by multiplying by
constant \code{a}. Equivalent to \code{\link[=multiply]{multiply()}}.}
\item{\code{d / a}}{Scales the distribution by dividing by constant \code{a}.
Equivalent to \code{multiply(d, 1/a)}.}
\item{\code{a / d}}{Returns the distribution of \code{a / X} (reciprocal scaling).
For \code{a = 1}, equivalent to \code{\link[=invert]{invert()}}.}
\item{\code{d ^ a}}{Raises the distribution to power \code{a}. For positive
distributions only, computed as \code{exp(a * log(d))}.}
\item{\code{a ^ d}}{Returns the distribution of \code{a^X}. Requires positive
base \code{a}.}
}
}

\section{Power Operator Details}{

The power operator \code{^} deserves special attention:
\itemize{
\item When the \strong{base is a distribution} (e.g., \code{dst_beta(1, 1)^2}),
it computes the distribution of \code{X^a} using the transformation
\code{exp(a * log(X))}. This requires all values in the distribution to be
positive.
\item When the \strong{exponent is a distribution} (e.g., \code{2^dst_norm(0, 1)}),
it computes the distribution of \code{a^X} using \code{exp(X * log(a))}.
The base \code{a} must be positive.
}

These implementations internally use both \code{\link[=Math.dst]{Math.dst()}} methods \code{log()}
and \code{exp()}.
}

\examples{
d <- distionary::dst_beta(3, 2)

# Shifting and scaling
d + 10          # Shift right by 10
d * 2           # Scale by 2
3 * d - 5       # Scale then shift

# Power operations
exp(d)          # e^X: exponential of Beta
2^d             # 2^X: base 2 raised to Beta

# With positive distributions
d_pos <- distionary::dst_unif(1, 2)
d_pos^2         # X^2: uniform squared
d_pos^0.5       # sqrt(X): square root
sqrt(d_pos)     # Equivalent to d_pos^0.5

}
\seealso{
\itemize{
\item \code{\link[=shift]{shift()}}, \code{\link[=multiply]{multiply()}}, \code{\link[=flip]{flip()}}, \code{\link[=invert]{invert()}} for the underlying
transformation functions
\item \code{\link[=Math.dst]{Math.dst()}} for \code{log()}, \code{exp()}, and \code{sqrt()} functions
}
}
